import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Color;
import types.DataClass;


class Wheel {
    DataClass m_Data;
    public Wheel(DataClass data) {
        m_Data = data;
    }
    public void paint(Graphics g,Rectangle frame) {
        int iAnz = m_Data.sequenceNumbers();
        // paint filled Arcs
        g.setColor(Color.yellow);
        g.fillArc(frame.x,frame.y,frame.width,frame.height,getArc(m_Data.upperBound()),m_Data.windowSize()*360/iAnz);
        g.setColor(Color.lightGray);
        g.fillArc(frame.x,frame.y,frame.width,frame.height,getArc(m_Data.lowerBound()),(m_Data.sequenceNumbers()-m_Data.windowSize())*360/iAnz);
        // paint shapes
        g.setColor(Color.black);
        int i;
        for (i=0;i<iAnz;i++) {
            int iAngle = getArc(i);
            double dAngle = 3.141592/180*((double)iAngle);
            int iRadX = frame.width/2;
            int iRadY = frame.height/2;
            int iDX = (int)((double)iRadX*Math.cos(dAngle));
            int iDY = (int)((double)iRadY*Math.sin(dAngle));
            if ((i==m_Data.lowerBound())||(i==m_Data.upperBound())) {
                g.setColor(Color.red);
//                g.fillArc(frame.x,frame.y,frame.width,frame.height,iAngle-10,20);
                g.drawLine(frame.x+iRadX,frame.y+iRadY,frame.x+iRadX+iDX,frame.y+iRadY-iDY);
            }
            else {
                g.setColor(Color.black);
                g.drawLine(frame.x+iRadX,frame.y+iRadY,frame.x+iRadX+iDX,frame.y+iRadY-iDY);
            }
        }
        g.setColor(Color.black);
        g.drawOval(frame.x,frame.y,frame.width,frame.height);
    }
    int getArc(int iNum) {
        return(360-(360*iNum/m_Data.sequenceNumbers()-90));
    }
}
